#define PROTOCOL_SPX   0
#define PROTOCOL_TCP   1

#define MAX_PROTOCOLS  2

extern int NetInit();
/*
   Initializes network subsystem.
   Returns 0 - error, 1 - ok
*/

extern void NetDeinit();
/*
   Deinitializes network subsystem.
*/

extern void* AllocateContext( int Protocol );
/*
  Allocates network context. Returns NULL in case of error.
*/

extern void DeallocateContext( void* Ctx );
/*
  Deallocates network context.
*/

extern SOCKADDR* GetPeerSockAddr( void* Ctx );
/*
  scanner needs this service
*/

extern int GetProtocol( void* Ctx );
/*
  Returns protocol id from context or MAX_PROTOCOLS if Ctx is NULL.
*/

extern char* GetProtocolName( int Protocol );
/*
  Returns protocol name or NULL for unspecified protocol.
*/

extern char* GetDefaultPort( int Protocol );
/*
  Returns default port for specified protocol in string representstion
  or NULL for unspecified protocol.
*/

extern void SetLocalPort( void* Ctx, char* Port );
/*
   Sets local address and specified port (uses dynamic port
   if Port == NULL or Port == "0").
*/

extern void GetLocalAddress( void* Ctx, char* Addr, char* Port );
/*
   Writes local address into Addr (must be at least 64 bytes)
   and port into Port (16 bytes is enough).
   Must be called after OpenPort or for a context returned
   by AcceptConnection.
*/

extern void GetDgramSrcAddress( void* Ctx, char* Addr, char* Port );
/*
  Call just after RecvData
*/


extern int SetPeerAddress( void* Ctx, char* Addr, char* Port );
/*
   Returns 1 - ok, 0 - invalid address format
   Address format examples:
     TCP: 10.10.20.22        IP address (dec numbers)
     SPX: 12312332           MAC address only (hex)
          454.3876327        network (hex) + MAC address (hex)
   Port may be NULL or "0" to use default.
*/

extern int OpenPort( void* Ctx );
extern int OpenDgramPort( void* Ctx );
/*
   Returns 1 -ok, 0-error.
*/

extern void ClosePort( void* Ctx );

extern int ListenForConnection( void* Ctx );
/*
   Puts socket into listen state.
   Returns 1 -ok, 0-error.
*/

extern void* AcceptConnection( void* Ctx );
/*
   Accepts incoming connection.
   Returns new context or NULL in case of error.
*/

extern int EstablishConnection( void* Ctx );
/*
   Returns 1 -ok, 0-error.
*/

extern int RecvData( void* Ctx, char* Buf, int BufSz );
extern int SendData( void* Ctx, char* Buf, int BufSz );
/*
   Returns 1 -ok, 0 -connection terminated.
   RecvData returns data size or -1 for datagramms
*/



/******** Hi-level API ****************/

typedef void (*SRPRINT)( char* Str );

extern void SendStringList( void* Ctx, STRINGLIST* s );
extern int  RecvStringList( void* Ctx, STRINGLIST* s );
extern int  RecvFile( void* Ctx, char* FileName, SRPRINT Callback );
extern int  SendFile( void* Ctx, char* FileName, SRPRINT Callback );

// error codes
#define ERRNET2_OK     0   // no error
#define ERRNET2_RECV   1   // reception error
#define ERRNET2_CRC    2   // CRC bad
#define ERRNET2_OPEN   3   // open/create - Recv/SendFile only
#define ERRNET2_RW     4   // read/write - Recv/SendFile only
#define ERRNET2_SEND   5   // transmission error - SendFile only
